// $Id: CVstExceptionHandler.cpp,v 1.7 2007/02/08 21:08:23 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
 */

#include "CVstExceptionHandler.hpp"
#include <IO/CTextStream.hpp>
#include <Host/CSystemInformation.hpp>
#include <Host/CFPUInformation.hpp>
#include <Host/CTime.hpp>
#include <Basics/CDialog.hpp>

using Exponent::GUI::Basics::CDialog;
using Exponent::Host::CTime;
using Exponent::Host::CSystemInformation;
using Exponent::Host::CFPUInformation;
using Exponent::IO::CTextStream;
using Exponent::Vst::CVstExceptionHandler;

//	===========================================================================
void CVstExceptionHandler::handleException(CException exception, const CHostCanDo &canDo, const CSystemString &path)
{
	// Get system stats
	SSystemInformation sys;
	CSystemInformation::getSystemInfo(sys);

	// Create the text stream
	CTextStream textStream(path, CTextStream::e_output);

	// Get the time and date
	CTime time;

	// Output the stream header
	textStream << "-------------------------------------" << "\n"
			   << "Exponent Vst Exception Handler Report" << "\n"
			   << time.getDayYearString()				  << "\n"
			   << "-------------------------------------" << "\n\n";

	// Output the system information
	textStream << "-------------------------------------"      << "\n"
			   << "System statistics"					       << "\n"
			   << "-------------------------------------"      << "\n"
			   << "System name : " << sys.m_computerName       << "\n"
			   << "User name   : " << sys.m_userName           << "\n"
			   << "O/S         : " << sys.m_osVersion	       << "\n"
			   << "Processor   : " << sys.m_processorString    << "\n"
			   << "CPU speed   : " << sys.m_cpuSpeed		   << "\n"
			   << "O/S version : " << sys.m_major			   << "."
								   << sys.m_minor			   << "."
								   << sys.m_build			   << "\n"
			   << "Num proc    : " << sys.m_numberOfProcessors << "\n"
			   << "-------------------------------------"      << "\n\n";

	// Output the FPU ifnroamtion
	textStream << "-------------------------------------"           		  << "\n"
			   << "FPU statistics"				      	            		  << "\n"
			   << "-------------------------------------"           		  << "\n"
			   << "Has MMX     : " << CFPUInformation::CPUHasMMX()  		  << "\n"
			   << "Has SSE     : " << CFPUInformation::CPUHasSSE()  		  << "\n"
			   << "Has SSE2    : " << CFPUInformation::CPUHasSSE2() 		  << "\n"
			   << "Has SSE3    : " << CFPUInformation::CPUHasSSE3()			  << "\n"
			   << "Has HT      : " << CFPUInformation::CPUHasHyperThreading() << "\n"
			   << "-------------------------------------"           		  << "\n\n";

	// Output the VST information
	textStream << "-------------------------------------"   		        	 << "\n"
			   << "VST information"									        	 << "\n"
			   << "-------------------------------------"			        	 << "\n"
			   << "Host name      : " << canDo.m_hostName.getString()			 << "\n"
			   << "Host version   : " << canDo.m_hostVersion					 << "\n"
			   << "Host developer : " << canDo.m_hostDeveloper.getString()		 << "\n"
			   << "-------------------------------------"			        	 << "\n"
			   << "Can do information"								        	 << "\n"
			   << "-------------------------------------"			        	 << "\n"
			   << "Send Vst Events        : " << canDo.m_sendVstEvents      	 << "\n"
			   << "Send Vst Midi Event    : " << canDo.m_sendVstMidiEvent   	 << "\n"
			   << "Send Vst Time Info     : " << canDo.m_sendVstTimeInfo    	 << "\n"
			   << "Recieve Vst Events     : " << canDo.m_recieveVstEvents   	 << "\n"
			   << "Recieve Vst Midi Event : " << canDo.m_receiveVstMidiEvent	 << "\n"
			   << "Recieve Vst Time Info  : " << canDo.m_receiveVstTimeInfo		 << "\n"
			   << "Report con'tion change : " << canDo.m_reportConnectionChanges << "\n"
			   << "Accept IO changes      : " << canDo.m_acceptIOChanges		 << "\n"
			   << "Size window            : " << canDo.m_sizeWindow				 << "\n"
			   << "Async Process          : " << canDo.m_asyncProcessing		 << "\n"
			   << "Offline                : " << canDo.m_offline				 << "\n"
			   << "Supply idle            : " << canDo.m_supplyIdle				 << "\n"
			   << "Support Shell          : " << canDo.m_supportShell			 << "\n"
			   << "Edit file              : " << canDo.m_editFile				 << "\n"
			   << "Close file selector    : " << canDo.m_closeFileSelector		 << "\n"
			   << "Start stop process     : " << canDo.m_startStopProcess		 << "\n"
			   << "-------------------------------------"						 << "\n\n";

	// Output the exception informaton
	textStream << "-------------------------------------"			<< "\n"
			   << "Exception Information"							<< "\n"
			   << "-------------------------------------"			<< "\n"
			   << "Function name : " << exception.getFunctionName() << "\n"
			   << "Error reason  : " << exception.getErrorReason()  << "\n"
			   << "-------------------------------------"			<< "\n\n";

	// Sort the classes
	CClass::getClassManager()->sortClasses();

	// Output the class information
	CClass::getClassManager()->logClassInformation(&textStream);

	// Close the file
	textStream.closeStream();

	// Now create a notification for the user
	CString message = "An Exception has occurred!\n";
	message += "Exception information :\n";
	message += exception.getFunctionName();
	message += "\n";
	message += exception.getErrorReason();
	message += "\n\n";
	message += "A Log file of this error has been created and is located :\n";
	message += path.getString();
	CDialog::notifyUser(message, "Exception occurred", true);
}

//	===========================================================================
void CVstExceptionHandler::preVstExceptionHandler(CException exception, const CSystemString &path)
{
	// Get system stats
	SSystemInformation sys;
	CSystemInformation::getSystemInfo(sys);

	// Create the text stream
	CTextStream textStream(path, CTextStream::e_output);

	// Get the time and date
	CTime time;

	// Output the stream header
	textStream << "-------------------------------------"     << "\n"
			   << "Exponent Pre Vst Exception Handler Report" << "\n"
			   << time.getDayYearString()				      << "\n"
			   << "-------------------------------------"     << "\n\n";

	// Output the system information
	textStream << "-------------------------------------"      << "\n"
			   << "System statistics"					       << "\n"
			   << "-------------------------------------"      << "\n"
			   << "System name : " << sys.m_computerName       << "\n"
			   << "User name   : " << sys.m_userName           << "\n"
			   << "O/S         : " << sys.m_osVersion	       << "\n"
			   << "Processor   : " << sys.m_processorString    << "\n"
			   << "CPU speed   : " << sys.m_cpuSpeed		   << "\n"
			   << "O/S version : " << sys.m_major			   << "."
								   << sys.m_minor			   << "."
								   << sys.m_build			   << "\n"
			   << "Num proc    : " << sys.m_numberOfProcessors << "\n"
			   << "-------------------------------------"      << "\n\n";

	// Output the FPU ifnroamtion
	textStream << "-------------------------------------"           		  << "\n"
			   << "FPU statistics"				      	            		  << "\n"
			   << "-------------------------------------"           		  << "\n"
			   << "Has MMX     : " << CFPUInformation::CPUHasMMX()  		  << "\n"
			   << "Has SSE     : " << CFPUInformation::CPUHasSSE()  		  << "\n"
			   << "Has SSE2    : " << CFPUInformation::CPUHasSSE2() 		  << "\n"
			   << "Has SSE3    : " << CFPUInformation::CPUHasSSE3()			  << "\n"
			   << "Has HT      : " << CFPUInformation::CPUHasHyperThreading() << "\n"
			   << "-------------------------------------"           		  << "\n\n";

	// Output the exception informaton
	textStream << "-------------------------------------"			<< "\n"
			   << "Exception Information"							<< "\n"
			   << "-------------------------------------"			<< "\n"
			   << "Function name : " << exception.getFunctionName() << "\n"
			   << "Error reason  : " << exception.getErrorReason()  << "\n"
			   << "-------------------------------------"			<< "\n\n";

	// Output the class information
	CClass::getClassManager()->logClassInformation(&textStream);

	// Close the file
	textStream.closeStream();

	// Now create a notification for the user
	CString message = "An Exception has occurred!\n";
	message += "Exception information :\n";
	message += exception.getFunctionName();
	message += "\n";
	message += exception.getErrorReason();
	message += "\n\n";
	message += "A Log file of this error has been created and is located :\n";
	message += path.getString();
	message += "\n";
	message += "Please email this file to plugins@expdigital.co.uk to assist us with bug fixes";

	// Notify the user and we are done..
	CDialog::notifyUser(message, "Exception occurred", true);
}